<?php
// process-lead-simple-fr.php - VERSIN COMPLETA PARA 6 FORMULARIOS
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// CONFIGURATION
define('SECURE_ACCESS', true);
require_once('/home/seojobs/config/api-keys.php');
require_once(__DIR__ . '/../config-country.php');

// IDs de campos personalizados
define('GR_FIELD_CIUDAD', 'z');
define('GR_FIELD_FECHA_REGISTRO', '9');

// TAG IDs REALES DE GETRESPONSE
$TAG_IDS = [
    'whatsapp_lead' => 'F',
    'sector_almacen' => 'j',
    'sector_tienda' => 'P',  // Tag para magasin/tienda
    'sector_oficina' => 'M',
    'sector_reparto' => 'D',
    'con_exp' => 'a',
    'sin_exp' => 'L'
];

// Obtener datos del formulario
$email = filter_var(trim($_POST['email'] ?? ''), FILTER_VALIDATE_EMAIL);
$nombre = trim($_POST['nombre'] ?? 'User');
$sector_tipo = $_POST['sector_tipo'] ?? '';
$experiencia_tipo = $_POST['experiencia_tipo'] ?? '';
$ciudad = trim($_POST['ciudad'] ?? 'Canada');

if (!$email) {
    die(json_encode(['success' => false, 'message' => 'Email invalide']));
}

// Determinar URL de redireccin segn el sector

if ($sector_tipo === 'almacen') {
    $redirect_url = 'https://caf.registrea.com/guide-emplois-entrepot/';
} elseif ($sector_tipo === 'tienda') {
    $redirect_url = 'https://caf.registrea.com/tout-sur-les-offres-demploi-en-magasin/'; // Ajusta si tienes URL especfica para tienda
} elseif ($sector_tipo === 'oficina') {
    $redirect_url = 'https://caf.registrea.com/offres-demploi-en-bureau-ce-quil-faut-vraiment-savoir/';
} elseif ($sector_tipo === 'reparto') {
    $redirect_url = 'https://caf.registrea.com/le-guide-pratique-du-livreur/';
}

// PASO 1: Crear o actualizar el contacto
$contactData = [
    'name' => $nombre,
    'email' => $email,
    'campaign' => ['campaignId' => GR_LIST_ID],
    'customFieldValues' => [
        ['customFieldId' => GR_FIELD_CIUDAD, 'value' => [$ciudad]],
        ['customFieldId' => GR_FIELD_FECHA_REGISTRO, 'value' => [date('Y-m-d H:i:s')]]
    ]
];

$ch = curl_init('https://api.getresponse.com/v3/contacts');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-Auth-Token: api-key ' . GR_API_KEY
]);

$result = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Si el contacto ya existe (409), actualizar sus campos
if ($httpCode === 409) {
    $searchUrl = 'https://api.getresponse.com/v3/contacts?query[email]=' . urlencode($email);
    
    $ch = curl_init($searchUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'X-Auth-Token: api-key ' . GR_API_KEY
    ]);
    
    $searchResult = curl_exec($ch);
    $contacts = json_decode($searchResult, true);
    curl_close($ch);
    
    if (!empty($contacts) && isset($contacts[0]['contactId'])) {
        $contactId = $contacts[0]['contactId'];
        
        $updateData = [
            'name' => $nombre,
            'customFieldValues' => [
                ['customFieldId' => GR_FIELD_CIUDAD, 'value' => [$ciudad]],
                ['customFieldId' => GR_FIELD_FECHA_REGISTRO, 'value' => [date('Y-m-d H:i:s')]]
            ]
        ];
        
        $ch = curl_init('https://api.getresponse.com/v3/contacts/' . $contactId);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($updateData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'X-Auth-Token: api-key ' . GR_API_KEY
        ]);
        
        curl_exec($ch);
        curl_close($ch);
    }
} else {
    sleep(2);
}

// PASO 2: Buscar el contacto para obtener su ID
$searchUrl = 'https://api.getresponse.com/v3/contacts?query[email]=' . urlencode($email);

$ch = curl_init($searchUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-Auth-Token: api-key ' . GR_API_KEY
]);

$searchResult = curl_exec($ch);
$contacts = json_decode($searchResult, true);
curl_close($ch);

if (!empty($contacts) && isset($contacts[0]['contactId'])) {
    $contactId = $contacts[0]['contactId'];
    
    // PASO 3: Preparar los tag IDs a asignar
    $tagsToAssign = [];
    
    // Tag base para WhatsApp
    $tagsToAssign[] = $TAG_IDS['whatsapp_lead'];
    
    // Tag del sector
    if ($sector_tipo === 'almacen') {
        $tagsToAssign[] = $TAG_IDS['sector_almacen'];
    } elseif ($sector_tipo === 'tienda') {
        $tagsToAssign[] = $TAG_IDS['sector_tienda'];
    } elseif ($sector_tipo === 'oficina') {
        $tagsToAssign[] = $TAG_IDS['sector_oficina'];
    } elseif ($sector_tipo === 'reparto') {
        $tagsToAssign[] = $TAG_IDS['sector_reparto'];
    }
    
    // Tag de experiencia
    if ($experiencia_tipo === 'con_exp') {
        $tagsToAssign[] = $TAG_IDS['con_exp'];
    } elseif ($experiencia_tipo === 'sin_exp') {
        $tagsToAssign[] = $TAG_IDS['sin_exp'];
    }
    
    // PASO 4: Asignar los tags al contacto
    foreach ($tagsToAssign as $tagId) {
        $tagUrl = "https://api.getresponse.com/v3/contacts/{$contactId}/tags";
        
        $tagData = [
            'tags' => [$tagId]
        ];
        
        $ch = curl_init($tagUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($tagData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'X-Auth-Token: api-key ' . GR_API_KEY
        ]);
        
        curl_exec($ch);
        curl_close($ch);
    }
}

// Respuesta exitosa
echo json_encode([
    'success' => true,
    'message' => 'Contact enregistr avec succs',
    'redirect' => $redirect_url
]);
?>