<?php
// process-lead-fr-v2.php - VERSION CON TAGS PARA FORMULARIO LARGO
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// No mostrar errores en producción
error_reporting(0);
ini_set('display_errors', 0);

// Cargar configuraciones
define('SECURE_ACCESS', true);
require_once('/home/seojobs/config/api-keys.php');
require_once(__DIR__ . '/../config-country.php');

// IDs de campos personalizados
define('GR_FIELD_CIUDAD', 'z');
define('GR_FIELD_FECHA_REGISTRO', '9');

// TAG IDs REALES DE GETRESPONSE
$TAG_IDS = [
    'sector_almacen' => 'j',
    'sector_tienda' => 'P',
    'sector_reparto' => 'D',
    'sector_oficina' => 'M',
    'cualquier_empleo' => 'I',
    'con_exp' => 'a',
    'sin_exp' => 'L',
    'form_v2' => 'A',
    'lead_mobile' => '4',
    'lead_desktop' => 'b'
];

// VALIDACIÓN DE ORIGEN (solo si hay referer)
$allowed_domains = ['seojobs.pro', 'www.seojobs.pro'];
$referer = parse_url($_SERVER['HTTP_REFERER'] ?? '', PHP_URL_HOST);

if (!empty($_SERVER['HTTP_REFERER']) && !in_array($referer, $allowed_domains)) {
    die(json_encode(['success' => false, 'message' => 'Accès non autorisé']));
}

// Verificar que lleguen datos
if (empty($_POST)) {
    die(json_encode([
        'success' => false,
        'message' => 'Aucune donnée reçue'
    ]));
}

// Validar reCAPTCHA (opcional)
$recaptcha = $_POST['recaptcha_token'] ?? '';
if (!empty($recaptcha)) {
    $verify_url = 'https://www.google.com/recaptcha/api/siteverify';
    $data = [
        'secret' => RECAPTCHA_SECRET,
        'response' => $recaptcha
    ];
    
    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data),
            'timeout' => 5
        ]
    ];
    
    $context = stream_context_create($options);
    $response = @file_get_contents($verify_url, false, $context);
    
    if ($response !== false) {
        $result = json_decode($response);
        
        if ($result && isset($result->success) && (!$result->success || $result->score < 0.3)) {
            error_log("reCAPTCHA score bajo: " . $result->score);
        }
    }
}

// Validar tiempo mínimo
$timestamp = intval($_POST['timestamp'] ?? 0);
if ($timestamp > 0 && (time() * 1000 - $timestamp < 2000)) {
    die(json_encode([
        'success' => false,
        'message' => 'Formulaire soumis trop rapidement'
    ]));
}

// Obtener y limpiar campos
$nombre = isset($_POST['nombre']) ? trim($_POST['nombre']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$ciudad = isset($_POST['ciudad']) ? trim($_POST['ciudad']) : COUNTRY_DEFAULT;
$sector = isset($_POST['sector']) ? trim($_POST['sector']) : '';
$experiencia = isset($_POST['experiencia']) ? trim($_POST['experiencia']) : '';
$device = isset($_POST['device']) ? $_POST['device'] : 'unknown';

// Validar email
$email = filter_var($email, FILTER_VALIDATE_EMAIL);

// Validación de campos requeridos
if (!$nombre || strlen($nombre) < 2) {
    die(json_encode([
        'success' => false,
        'message' => 'Prénom invalide'
    ]));
}

if (!$email) {
    die(json_encode([
        'success' => false,
        'message' => 'Email invalide'
    ]));
}

if (!$sector || !$experiencia) {
    die(json_encode([
        'success' => false,
        'message' => 'Veuillez remplir tous les champs'
    ]));
}

// PASO 1: Crear o actualizar contacto
$contactData = [
    'name' => $nombre,
    'email' => $email,
    'campaign' => [
        'campaignId' => GR_LIST_ID
    ],
    'customFieldValues' => [
        ['customFieldId' => GR_FIELD_CIUDAD, 'value' => [$ciudad]],
        ['customFieldId' => GR_FIELD_FECHA_REGISTRO, 'value' => [date('Y-m-d H:i:s')]]
    ],
    'ipAddress' => $_SERVER['REMOTE_ADDR'] ?? null
];

$ch = curl_init('https://api.getresponse.com/v3/contacts');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-Auth-Token: api-key ' . GR_API_KEY
]);

$result = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Si el contacto ya existe (409), actualizar campos
if ($httpCode === 409) {
    $searchUrl = 'https://api.getresponse.com/v3/contacts?query[email]=' . urlencode($email);
    
    $ch = curl_init($searchUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'X-Auth-Token: api-key ' . GR_API_KEY
    ]);
    
    $searchResult = curl_exec($ch);
    $contacts = json_decode($searchResult, true);
    curl_close($ch);
    
    if (!empty($contacts) && isset($contacts[0]['contactId'])) {
        $contactId = $contacts[0]['contactId'];
        
        $updateData = [
            'customFieldValues' => [
                ['customFieldId' => GR_FIELD_CIUDAD, 'value' => [$ciudad]],
                ['customFieldId' => GR_FIELD_FECHA_REGISTRO, 'value' => [date('Y-m-d H:i:s')]]
            ]
        ];
        
        $ch = curl_init('https://api.getresponse.com/v3/contacts/' . $contactId);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($updateData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'X-Auth-Token: api-key ' . GR_API_KEY
        ]);
        
        curl_exec($ch);
        curl_close($ch);
    }
} elseif ($httpCode === 202) {
    sleep(2);
}

// PASO 2: Buscar el contacto y añadir tags
$searchUrl = 'https://api.getresponse.com/v3/contacts?query[email]=' . urlencode($email);

$ch = curl_init($searchUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-Auth-Token: api-key ' . GR_API_KEY
]);

$searchResult = curl_exec($ch);
$contacts = json_decode($searchResult, true);
curl_close($ch);

if (!empty($contacts) && isset($contacts[0]['contactId'])) {
    $contactId = $contacts[0]['contactId'];
    
    // Preparar tags a asignar
    $tagsToAssign = [];
    
    // Tag del formulario
    $tagsToAssign[] = $TAG_IDS['form_v2'];
    
    // Tag del dispositivo
    if ($device === 'mobile') {
        $tagsToAssign[] = $TAG_IDS['lead_mobile'];
    } else {
        $tagsToAssign[] = $TAG_IDS['lead_desktop'];
    }
    
    // Tag del sector
    if ($sector === 'entrepot') {
        $tagsToAssign[] = $TAG_IDS['sector_almacen'];
    } elseif ($sector === 'magasin') {
        $tagsToAssign[] = $TAG_IDS['sector_tienda'];
    } elseif ($sector === 'livraison') {
        $tagsToAssign[] = $TAG_IDS['sector_reparto'];
    } elseif ($sector === 'bureau') {
        $tagsToAssign[] = $TAG_IDS['sector_oficina'];
    } elseif ($sector === 'nimporte') {
        $tagsToAssign[] = $TAG_IDS['cualquier_empleo'];
    }
    
    // Tag de experiencia
    if ($experiencia === 'sans') {
        $tagsToAssign[] = $TAG_IDS['sin_exp'];
    } elseif ($experiencia === 'avec') {
        $tagsToAssign[] = $TAG_IDS['con_exp'];
    }
    
    // Asignar cada tag
    foreach ($tagsToAssign as $tagId) {
        $tagUrl = "https://api.getresponse.com/v3/contacts/{$contactId}/tags";
        
        $tagData = [
            'tags' => [$tagId]
        ];
        
        $ch = curl_init($tagUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($tagData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'X-Auth-Token: api-key ' . GR_API_KEY
        ]);
        
        curl_exec($ch);
        curl_close($ch);
    }
}

// Preparar URL de redirección
$redirect_url = '/confirmation-email.html?n=' . urlencode($nombre) . 
                '&c=' . urlencode($ciudad) . 
                '&s=' . urlencode($sector) . 
                '&x=' . urlencode($experiencia) .
                '&e=' . urlencode($email);

// Respuesta exitosa
echo json_encode([
    'success' => true,
    'message' => 'Lead enregistré correctement',
    'redirect' => $redirect_url
]);
?>