<?php
// geo-detect.php - USANDO HEADERS DE CLOUDFLARE
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Cloudflare añade estos headers automáticamente
$city = $_SERVER['HTTP_CF_IPCITY'] ?? null;
$country = $_SERVER['HTTP_CF_IPCOUNTRY'] ?? null;
$ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['REMOTE_ADDR'];

if ($city) {
    echo json_encode([
        'city' => $city,
        'country' => $country,
        'ip' => $ip
    ]);
} else {
    // Fallback a IP-API
    $response = @file_get_contents("http://ip-api.com/json/{$ip}?fields=city,country");
    $data = json_decode($response, true);
    echo json_encode([
        'city' => $data['city'] ?? null,
        'country' => $data['country'] ?? null
    ]);
}
?>