## 🌍 REPLICACIÓN PARA NUEVOS PAÍSES

### **Estructura por País:**
```
/public_html/
├── caf/          ← Canadá (Francia)
├── es/           ← España  
├── it/           ← Italia
├── de/           ← Alemania
└── config/       ← APIs globales (NUNCA duplicar)
```

### **Pasos para Crear Nuevo País:**

#### **1. Duplicar Carpeta Base**
```bash
# Ejemplo para España
cp -r /caf/ /es/
```

#### **2. Archivos a Modificar por País:**

**📝 config-country.php**
```php
<?php
// CONFIGURACIÓN ESPECÍFICA DEL PAÍS
define('GR_LIST_ID', 'M');  // ← Cambiar ID de lista
define('COUNTRY_DEFAULT', 'España');  // ← Cambiar país por defecto

// URLs de redirección por sector
$REDIRECT_URLS = [
    'almacen' => 'https://es.registrea.com/guide-emplois-entrepot/',  // ← Cambiar URLs
    'tienda' => 'https://es.registrea.com/magasin/',
    'oficina' => 'https://es.registrea.com/oficina/',
    'reparto' => 'https://es.registrea.com/conductor/'
];
?>
```

**📝 Formularios HTML (6 archivos)**
Cambiar en el JavaScript de cada formulario:
```javascript
// BUSCAR estas líneas:
apiEndpoint: '/caf/api/process-lead-simple-fr.php'
geoApiEndpoint: '/caf/api/geo-detect.php'

// CAMBIAR A:
apiEndpoint: '/es/api/process-lead-simple-fr.php'
geoApiEndpoint: '/es/api/geo-detect.php'
```

**📝 geo-detect.php**
```javascript
// BUSCAR:
let ciudad = 'Canada';

// CAMBIAR A:
let ciudad = 'España';  // ← País por defecto
```

---

## 📊 CONFIGURACIÓN GETRESPONSE POR PAÍS

| País | Código | Lista ID | Carpeta | URLs Base |
|------|--------|----------|---------|-----------|
| Canadá FR | CAF | A | /caf/ | caf.registrea.com |
| España | ES | M | /es/ | es.registrea.com |
| Francia | FR | G | /fr/ | fr.registrea.com |
| Italia | IT | 4 | /it/ | it.registrea.com |
| Alemania | DE | b | /de/ | de.registrea.com |

---

## 🔧 ARCHIVOS QUE NUNCA SE TOCAN

### **❌ NO DUPLICAR ESTOS ARCHIVOS:**
- `/home/seojobs/config/api-keys.php` ← APIs globales
- `/api/process-lead-simple-fr.php` ← Se replica automáticamente
- `/api/process-lead-fr-v2.php` ← Se replica automáticamente
- `/api/geo-detect.php` ← Se replica automáticamente

### **✅ ARCHIVOS A MODIFICAR POR PAÍS:**
- `config-country.php` ← Configuración específica
- `*.html` ← Formularios (cambiar rutas API)
- `confirmation-email.html` ← Ajustar URLs de redirección

---

## 🚀 PROCESO RÁPIDO DE REPLICACIÓN

### **Comando de Creación Completa:**
```bash
# 1. Duplicar carpeta
cp -r /public_html/caf/ /public_html/NUEVO_PAIS/

# 2. Editar config-country.php
nano /public_html/NUEVO_PAIS/config-country.php

# 3. Buscar y reemplazar en formularios HTML
sed -i 's|/caf/api/|/NUEVO_PAIS/api/|g' /public_html/NUEVO_PAIS/*.html

# 4. Ajustar geo-detect.php
sed -i 's|Canada|NOMBRE_PAIS|g' /public_html/NUEVO_PAIS/api/geo-detect.php
```

---

## 🔗 URLs PARA MANYCHAT

```
https://seojobs.pro/PAIS/form-entrepot-exp.html?n={{first_name}}
https://seojobs.pro/PAIS/form-entrepot-sin-exp.html?n={{first_name}}
https://seojobs.pro/PAIS/form-reparto-exp.html?n={{first_name}}
https://seojobs.pro/PAIS/form-reparto-sin-exp.html?n={{first_name}}
https://seojobs.pro/PAIS/form-tienda-exp.html?n={{first_name}}
https://seojobs.pro/PAIS/form-tienda-sin-exp.html?n={{first_name}}
```

---

## ⚠️ CHECKLIST SEGURIDAD

### **Antes de Publicar Nuevo País:**
- [ ] APIs no están hardcodeadas en archivos PHP
- [ ] config-country.php tiene configuración correcta
- [ ] Formularios apuntan a rutas correctas del país
- [ ] URLs de redirección son correctas
- [ ] Lista de GetResponse existe y es correcta
- [ ] Geo-detección usa país correcto por defecto

### **Verificación Final:**
```bash
# Verificar que no hay APIs expuestas
grep -r "is43g8j8cb" /public_html/NUEVO_PAIS/
# Resultado debe estar vacío

# Verificar configuración
cat /public_html/NUEVO_PAIS/config-country.php
```

---

## 🎯 RESUMEN EJECUTIVO

**SEGURIDAD**: Las APIs están completamente protegidas fuera de public_html con doble protección.

**REPLICACIÓN**: Solo necesitas duplicar carpeta, cambiar 3 valores en config-country.php y ajustar rutas en formularios HTML.

**MANTENIMIENTO**: Un solo archivo de APIs para todos los países. Cambios globales se aplican automáticamente.

---

📅 **Última actualización**: Septiembre 2025  
🔒 **Nivel de seguridad**: ALTO  
🌍 **Países soportados**: Ilimitados con misma infraestructura